<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Agent extends Model 
{

    protected $table = 'agents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function myBranch()
    {
        return $this->belongsTo('App\Models\Branch', 'branch_id');
    }

    public function myClients()
    {
        return $this->belongsToMany('App\Models\Client', 'agents_id');
    }

}